ORCA/M Asm65816 2.1.0

0001 7797
0002 7797                       INCLUDE ':::qd:QDEquates:CORE.GLOBALS1' 
0003 7797
0004 7797                       title 'Cursor Equates' 
0005 7797
0006 7797              ScreenStart equ   $2000
0007 7797              ScreenHeight equ   200                  ; number of scan lines
0008 7797              ScreenWidth equ   160                   ; number of bytes
0009 7797
0010 7797              ScreenTable equ   $FE553C
0011 7797              ROMUnDrawCursor equ   $FE54B6
0012 7797              MaxWidth equ   32                       ; max number of bytes containing
0013 7797              *                                       ; single line of cursor image.
0014 7797
0015 7797              ;-----------------------------------------------
0016 7797              ;
0017 7797              ; We start the cursor data on zero page at the end
0018 7797              ; of the stuff used by the rest of quickdraw.
0019 7797              ;
0020 7797              StartofZP equ   CursorSTART
0021 7797
0022 7797              UseInterrupts equ   StartofZP
0023 7797              IntPending equ   UseInterrupts+2
0024 7797
0025 7797              MouseY   equ   IntPending+2
0026 7797              MouseX   equ   MouseY+2
0027 7797
0028 7797              NextMouseY equ   MouseX+2
0029 7797              NextMouseX equ   NextMouseY+2
0030 7797
0031 7797              CurHeight equ   NextMouseX+2            ; Num scan lines high of cursor
0032 7797              CurWidth equ   CurHeight+2              ; Num WORDS wide of cursor
0033 7797
0034 7797              CursorRect equ   CurWidth+2
0035 7797              CursorY1 equ   CursorRect
0036 7797              CursorX1 equ   CursorY1+2
0037 7797              CursorY2 equ   CursorX1+2
0038 7797              CursorX2 equ   CursorY2+2
0039 7797
0040 7797              CursorMode equ   CursorX2+2
0041 7797              CursorRecPtr equ   CursorMode+2
0042 7797
0043 7797              CursorPtr equ   CursorRecPtr+4
0044 7797              MaskPtr  equ   CursorPtr+4
0045 7797
0046 7797              CursorPtr1 equ   MaskPtr+4
0047 7797              MaskPtr1 equ   CursorPtr1+4
0048 7797              CursorPtr2 equ   MaskPtr1+4
0049 7797              MaskPtr2 equ   CursorPtr2+4
0050 7797              CursorPtr3 equ   MaskPtr2+4
0051 7797              MaskPtr3 equ   CursorPtr3+4
0052 7797              CursorPtr4 equ   MaskPtr3+4
0053 7797              MaskPtr4 equ   CursorPtr4+4
0054 7797              CursorPtr5 equ   MaskPtr4+4
0055 7797              MaskPtr5 equ   CursorPtr5+4
0056 7797              CursorPtr6 equ   MaskPtr5+4
0057 7797              MaskPtr6 equ   CursorPtr6+4
0058 7797              CursorPtr7 equ   MaskPtr6+4
0059 7797              MaskPtr7 equ   CursorPtr7+4
0060 7797
0061 7797              SaveHandle equ   MaskPtr7+4
0062 7797
0063 7797              SavePtr  equ   SaveHandle+4
0064 7797              SaveSize equ   SavePtr+4
0065 7797
0066 7797              CursorRef equ   SaveSize+2
0067 7797              MaskRef  equ   CursorRef+4
0068 7797              HotSpot  equ   MaskRef+4
0069 7797
0070 7797              SaveRef  equ   HotSpot+4
0071 7797              ScreenRef equ   SaveRef+4
0072 7797
0073 7797              CursorLevel equ   ScreenRef+2
0074 7797              ObscureFlag equ   CursorLevel+2
0075 7797
0076 7797              StartWord equ   ObscureFlag+2
0077 7797
0078 7797              ScreenIndex equ   StartWord+2
0079 7797              SaveIndex equ   ScreenIndex+2
0080 7797              CurrentY equ   SaveIndex+2
0081 7797
0082 7797              ThisOut  equ   CurrentY+2
0083 7797              LastOut  equ   ThisOut+2
0084 7797              SrcRef   equ   LastOut+2
0085 7797              DestRef  equ   SrcRef+4
0086 7797              ThisWord equ   DestRef+4
0087 7797
0088 7797              HowManyWords equ   ThisWord+2
0089 7797              WordCount equ   HowManyWords+2
0090 7797              LineCount equ   WordCount+2
0091 7797              HowFarToShift equ   LineCount+2
0092 7797
0093 7797              CursorFlags equ   HowFarToShift+2
0094 7797              TempRect equ   CursorFlags+2
0095 7797              SaveRect equ   TempRect+8
0096 7797
0097 7797              ZZEndofCursor equ   SaveRect+8
0098 7797
0099 7797              Busy_M   equ   $8000
0100 7797              Shielded_M equ   $4000
0101 7797              ForceU_M equ   $2000
0102 7797              ***SetCursorFlag	equ	$0100	; flag used to say don't refresh backsave..
0103 7797              SetCursorFlag equ   $2000
0104 7797
0105 7797                       title 'UndrawCursor' 
0106 7797              ****************************************************************
0107 7797              *
0108 7797              * iUndrawCursor
0109 7797              *
0110 7797              *
0111 7797              * 4/10/90           Mensch
0112 7797              *
0113 7797              * Added patch to allow for cursor handle being unlocked......
0114 7797              *
0115 7797              *
0116 7797              ****************************************************************
0117 7797              iUndrawCursor PROC EXPORT 
0118 7797 20 E4 7B              jsr   ReCalcCursorPtrs
0119 779A 5C B6 54 FE           jml   ROMUnDrawCursor          ; and recall the ROM undraw routine
0120 779E                       EndP 
0121 779E
0122 779E                       title 'DrawCursor' 
0123 779E              ****************************************************************
0124 779E              *
0125 779E              * iDrawCursor
0126 779E              *
0127 779E              * What the hey, this draws the cursor at the position
0128 779E              * indicated on zp.
0129 779E              *
0130 779E              * Change History
0131 779E              *
0132 779E              * 21 Aug 86     SEG      The calculation of the saveRect was
0133 779E              *        wrong.  A test for which mode branched
0134 779E              *        wrong for the 2 possible cases making
0135 779E              *        the 320 mode save rect too big and the
0136 779E              *        640 mode save rect too small.
0137 779E              *
0138 779E              *        There is a calculation where I must add
0139 779E              *        8 to a value.  I know the carry is set
0140 779E              *        so I saved a byte and added 7 without
0141 779E              *        touching the carry.
0142 779E              *
0143 779E              * 2/1/89    Mensch
0144 779E              *
0145 779E              * Added support for shadowed bank cursor...
0146 779E              *
0147 779E              * 4/6/90    Mensch
0148 779E              * Added support for non-flashing cursors
0149 779E              * This entails not redrawing the cursor if a certain bit is set in the cursor mode
0150 779E              * word...
0151 779E              *
0152 779E              ****************************************************************
0153 779E              iDrawCursor PROC EXPORT 
0154 779E
0155 779E              ;-------------------------------------------------
0156 779E              ;
0157 779E              ; First we set up the bank.
0158 779E
0159 779E 8B                    phb                            ; save the current bank
0160 779F 8F 34 12 FE           sta   >$FE1234
0161 77A3              ;
0162 77A3              ; Now unlock the cursor handle...
0163 77A3 A0 04 00              ldy   #4
0164 77A6 B7 B0                 lda   [SaveHandle],y
0165 77A8 29 FF 7F              and   #$7FFF
0166 77AB 97 B0                 sta   [SaveHandle],y
0167 77AD
0168 77AD 20 E4 7B              jsr   ReCalcCursorPtrs
0169 77B0              ;
0170 77B0              ; Find out if we are shadowed...
0171 77B0 AF 35 C0 E0           lda   >$E0C035                 ; get the shadow register
0172 77B4 29 08 00              and   #$0008                   ; test the shadowing flags!
0173 77B7 D0 05                 bne   @1                       ; if zero, then shadowing is on
0174 77B9 F4 01 01              pea   $0101                    ; push on the shadowed bank
0175 77BC 80 03                 bra   @2
0176 77BE
0177 77BE F4 E1 E1     @1       pea   $E1E1                    ; push this on stack
0178 77C1 AB           @2       plb                            ; set bank twice to
0179 77C2 AB                    plb                            ; clear stack
0180 77C3
0181 77C3
0182 77C3              ;-------------------------------------------------
0183 77C3              ;
0184 77C3              ; Next we set up the cursor rectangle
0185 77C3
0186 77C3 A5 56                 lda   MouseY
0187 77C5 38                    sec   
0188 77C6 E5 C2                 sbc   HotSpot
0189 77C8 85 62                 sta   CursorY1
0190 77CA 85 F8                 sta   SaveRect
0191 77CC 85 D6                 sta   CurrentY
0192 77CE 18                    clc   
0193 77CF 65 5E                 adc   CurHeight
0194 77D1 85 66                 sta   CursorY2
0195 77D3 85 FC                 sta   SaveRect+4
0196 77D5
0197 77D5 A5 58                 lda   MouseX
0198 77D7 38                    sec   
0199 77D8 E5 C4                 sbc   HotSpot+2
0200 77DA 85 64                 sta   CursorX1
0201 77DC 85 FA                 sta   SaveRect+2
0202 77DE
0203 77DE A5 60                 lda   CurWidth                 ; get width in words
0204 77E0 0A                    asl   a                        ; make it  bytes
0205 77E1 0A                    asl   a                        ; make it pixels for 320 mode
0206 77E2
0207 77E2 24 69                 bit   CursorMode-1
0208 77E4 10 01                 bpl   Width320                 ; Fixed 21 Aug 86
0209 77E6 0A                    asl   a
0210 77E7 18           Width320 clc   
0211 77E8 65 64                 adc   CursorX1
0212 77EA 85 68                 sta   CursorX2
0213 77EC 85 FE                 sta   SaveRect+6
0214 77EE
0215 77EE
0216 77EE              ;-----------------------------------------------
0217 77EE              ;
0218 77EE              ; Now I calculate the real bounds of the 
0219 77EE              ; SaveRect.
0220 77EE              ;  
0221 77EE 18                    clc                            ; clear carry for use later
0222 77EF A9 FC FF              lda   #%1111111111111100       ; load a with mask for 320 mode
0223 77F2 24 69                 bit   CursorMode-1             ; check real mode
0224 77F4 10 01                 bpl   Still320                 ; if not 320 mode put one more
0225 77F6 0A                    asl   a                        ; zero at low and and set carry!
0226 77F7 A8           Still320 tay                            ; put copy of mask in y
0227 77F8 25 FA                 and   SaveRect+2               ; and with left edge of rect
0228 77FA 85 FA                 sta   SaveRect+2               ; and save it
0229 77FC 98                    tya                            ; get make back
0230 77FD 25 FE                 and   SaveRect+6               ; and with right edge
0231 77FF B0 05                 bcs   Still640                 ; if carry is clear then we know
0232 7801 69 04 00              adc   #4                       ; that we were in 320 mode
0233 7804 80 03                 bra   SaveRtEdge               ; so add 4 and save rt edge
0234 7806              Still640                                ; ; otherwise add 8 and save rt edge
0235 7806 69 07 00              adc   #7                       ; note that carry was set to get here
0236 7809              ;       ; and adding 7 with carry set is like
0237 7809              ;       ; adding 8. (sorry to those who follow)
0238 7809              ;       ; This changed on
0239 7809              ;       ;    Aug 21, 1986
0240 7809              ;       ; by SEG
0241 7809
0242 7809 85 FE        SaveRtEdge sta   SaveRect+6
0243 780B
0244 780B
0245 780B              ;-------------------------------------------------
0246 780B              ;
0247 780B              ; Set up the StartWord (we don't use FinishWord) then 
0248 780B              ; Figure out which preshifted image to use and put
0249 780B              ; pointer to it in CursorRef and MaskRef.
0250 780B              ;
0251 780B 24 69                 bit   CursorMode-1
0252 780D 30 12                 bmi   Mode640
0253 780F
0254 780F A5 64                 lda   CursorX1                 ; make x value into byte
0255 7811 0A                    asl   a                        ; get sign into c
0256 7812 A5 64                 lda   CursorX1
0257 7814 6A                    ror   a                        ; preserve sign
0258 7815 29 FE FF              and   #$FFFE                   ; make even
0259 7818 85 D0                 sta   StartWord
0260 781A
0261 781A A5 64                 lda   CursorX1                 ; which preshifted image do I use?
0262 781C 29 03 00              and   #3
0263 781F 80 13                 bra   GetReady
0264 7821
0265 7821
0266 7821              Mode640                                 ;
0267 7821 A5 64                 lda   CursorX1                 ; make x value into byte
0268 7823 0A                    asl   a                        ; get sign into c
0269 7824 08                    php                            ; and save it
0270 7825 A5 64                 lda   CursorX1
0271 7827 6A                    ror   a                        ; preserve sign
0272 7828 28                    plp   
0273 7829 6A                    ror   a                        ; rotate again preserving sign
0274 782A 29 FE FF              and   #$FFFE                   ; make even
0275 782D 85 D0                 sta   StartWord
0276 782F
0277 782F A5 64                 lda   CursorX1                 ; determin which of the preshifted
0278 7831 29 07 00              and   #7                       ; images to use
0279 7834
0280 7834 0A           GetReady asl   a                        ; use number in a as index into
0281 7835 0A                    asl   a                        ; pointers on zp
0282 7836 0A                    asl   a
0283 7837 AA                    tax   
0284 7838
0285 7838 B5 70                 lda   CursorPtr,x
0286 783A 85 BA                 sta   CursorRef
0287 783C B5 71                 lda   CursorPtr+1,x
0288 783E 85 BB                 sta   CursorRef+1
0289 7840
0290 7840 B5 74                 lda   MaskPtr,x
0291 7842 85 BE                 sta   MaskRef
0292 7844 B5 75                 lda   MaskPtr+1,x
0293 7846 85 BF                 sta   MaskRef+1
0294 7848
0295 7848              ;-------------------------------------------------
0296 7848              ;
0297 7848              ; Set up other important vars for looping.
0298 7848              ;
0299 7848
0300 7848 A5 B4                 lda   SavePtr                  ; put the pointer to the beginning
0301 784A 85 C6                 sta   SaveRef                  ; of the save area into SaveRef
0302 784C A5 B5                 lda   SavePtr+1                ; (which will be bumped for each 
0303 784E 85 C7                 sta   SaveRef+1                ; scan line)
0304 7850
0305 7850
0306 7850 A5 62                 lda   CursorY1
0307 7852 85 D6                 sta   CurrentY
0308 7854
0309 7854 A5 6A                 lda   CursorMode               ; see if we should backsave the new data
0310 7856 29 00 01              and   #$0100
0311 7859 F0 0A                 beq   @1
0312 785B
0313 785B A5 6A                 lda   CursorMode               ; and take this oportunity to turn off this bit
0314 785D 29 FF FE              and   #$FEFF                   ; strip just that bit...
0315 7860 85 6A                 sta   CursorMode
0316 7862
0317 7862 A9 FF FF              lda   #$FFFF
0318 7865 85 EC        @1       sta   HowFarToShift            ; we reuse cursor <X> just for grins here
0319 7867
0320 7867              ;-------------------------------------------------
0321 7867              ;
0322 7867              ; The Outer Loop
0323 7867              ;
0324 7867              ;    For each scan line (CursorY1 thru CursorY2)
0325 7867              ;
0326 7867              OuterLoop                               ;
0327 7867
0328 7867 A5 D6                 lda   CurrentY
0329 7869 10 03                 bpl   NotAbove
0330 786B 4C C6 7B              jmp   BumpVertCounters
0331 786E
0332 786E C9 C8 00     NotAbove cmp   #ScreenHeight
0333 7871 30 03                 bmi   NotBelow
0334 7873 4C E2 7B              jmp   AllDone
0335 7876
0336 7876 C5 66        NotBelow cmp   CursorY2
0337 7878 30 03                 bmi   YesDoIt
0338 787A 4C E2 7B              jmp   AllDone
0339 787D
0340 787D              YesDoIt                                 ;
0341 787D
0342 787D              ;-------------------------------------------------
0343 787D              ;
0344 787D              ; Now I set up the loop to save the screen,
0345 787D              ; or in the mask and eor in the cursor all in
0346 787D              ; one loop
0347 787D              ;
0348 787D A5 60                 lda   CurWidth                 ; init the word count again (1 more
0349 787F 3A                    dec   a
0350 7880 85 E8                 sta   WordCount                ; than before)
0351 7882
0352 7882 A5 D0                 lda   StartWord                ; Screen Index starts at start word
0353 7884 85 D2                 sta   ScreenIndex
0354 7886
0355 7886 A5 D6                 lda   CurrentY                 ; ScreenRef is created from current
0356 7888 0A                    asl   a                        ; Y
0357 7889 AA                    tax   
0358 788A BF 3C 55 FE           lda   >ScreenTable,x
0359 788E 85 CA                 sta   ScreenRef
0360 7890
0361 7890 64 D4                 stz   SaveIndex                ; Save index starts at zero
0362 7892
0363 7892
0364 7892 A4 D2        DrawLoop ldy   ScreenIndex              ; get screen index
0365 7894 30 26                 bmi   OffScrnH                 ; and see if it points ot real
0366 7896 C0 A0 00              cpy   #ScreenWidth             ; screen
0367 7899 10 21                 bpl   OffScrnH
0368 789B
0369 789B B1 CA                 lda   (ScreenRef),y            ; Save under cursor
0370 789D A4 D4                 ldy   SaveIndex                ; put in save buffer
0371 789F              ; put in code here to muffle the save if needed...
0372 789F 24 EC                 bit   HowFarToShift            ; now contains our flag...
0373 78A1 30 02                 bmi   @1
0374 78A3 97 C6                 sta   [SaveRef],y
0375 78A5              @1        
0376 78A5 17 BE                 ora   [MaskRef],y              ; NOTE: save some fancy <Y> shuffling
0377 78A7 BB                    tyx                            ; need to have this in <X>
0378 78A8
0379 78A8              ; Was ...	lda	[MaskRef],y	; get word from mask
0380 78A8              ;	tyx		; save this here for quick access
0381 78A8              ;	ldy	ScreenIndex	; get this back
0382 78A8              ;	ora	(ScreenRef),y	; or with screen
0383 78A8              ;	txy
0384 78A8
0385 78A8 57 BA                 eor   [CursorRef],y            ; eor with rotated cursor
0386 78AA A4 D2                 ldy   ScreenIndex
0387 78AC 91 CA                 sta   (ScreenRef),y            ; store in screen
0388 78AE
0389 78AE E8                    inx                            ; bump this now that is in a register
0390 78AF E8                    inx                            ; register
0391 78B0 86 D4                 stx   SaveIndex
0392 78B2 C8                    iny                            ; bump this now since it is in a
0393 78B3 C8                    iny                            ; register
0394 78B4 84 D2                 sty   ScreenIndex
0395 78B6
0396 78B6 C6 E8        FinishLoop dec   WordCount              ; dec the word count and
0397 78B8 10 D8                 bpl   DrawLoop                 ; repeat till done
0398 78BA 80 0A                 bra   BumpVertCounters         ; now bump vert counters
0399 78BC
0400 78BC
0401 78BC E6 D2        OffScrnH inc   ScreenIndex              ; These were not bumped
0402 78BE E6 D2                 inc   ScreenIndex              ; in loop since cursor was clipped
0403 78C0 E6 D4                 inc   SaveIndex
0404 78C2 E6 D4                 inc   SaveIndex
0405 78C4 80 F0                 bra   FinishLoop
0406 78C6
0407 78C6
0408 78C6              BumpVertCounters                        ; 
0409 78C6 E6 D6                 inc   CurrentY
0410 78C8
0411 78C8 A5 60                 lda   CurWidth                 ; use this to calc width
0412 78CA 0A                    asl   a
0413 78CB AA                    tax                            ; save in x
0414 78CC 18                    clc                            ; add to cursor ref
0415 78CD 65 BA                 adc   CursorRef
0416 78CF 85 BA                 sta   CursorRef
0417 78D1
0418 78D1 8A                    txa                            ; add to mask ref
0419 78D2 18                    clc   
0420 78D3 65 BE                 adc   MaskRef
0421 78D5 85 BE                 sta   MaskRef
0422 78D7
0423 78D7 8A                    txa                            ; inc once and add to SaveRef
0424 78D8 1A                    inc   a
0425 78D9 1A                    inc   a
0426 78DA 18                    clc   
0427 78DB 65 C6                 adc   SaveRef
0428 78DD 85 C6                 sta   SaveRef
0429 78DF
0430 78DF
0431 78DF 4C 67 7B              jmp   OuterLoop
0432 78E2
0433 78E2              AllDone   
0434 78E2
0435 78E2 AB                    plb                            ; restore stack
0436 78E3 6B                    rtl   
0437 78E4
0438 78E4                       ENDP 
0439 78E4
0440 78E4              ReCalcCursorPtrs proc Export 
0441 78E4              ;
0442 78E4              ; This routine can be called by the draw or erase routines to determine if the
0443 78E4              ; cursor ptrs are correctly set up, this will allow us to leave the cursor image
0444 78E4              ; unlocked once its created so that it can move whenever needed
0445 78E4              ; NOTE: This relies on savesize being set properly...
0446 78E4              ;
0447 78E4              ; First determine if the handle has moved since the last time...
0448 78E4 A5 B4                 lda   SavePtr
0449 78E6 C7 B0                 cmp   [SaveHandle]
0450 78E8 D0 0A                 bne   @DoRecalc
0451 78EA A0 02 00              ldy   #2
0452 78ED A5 B6                 lda   SavePtr+2
0453 78EF D7 B0                 cmp   [SaveHandle],y
0454 78F1 D0 01                 bne   @DoRecalc
0455 78F3 60                    rts                            ; else, the pointers are set up just fine
0456 78F4              @DoRecalc  
0457 78F4 A0 02 00              ldy   #2
0458 78F7 B7 B0                 lda   [SaveHandle],y
0459 78F9 85 B6                 sta   SavePtr+2
0460 78FB A7 B0                 lda   [SaveHandle]
0461 78FD 85 B4                 sta   SavePtr
0462 78FF
0463 78FF A5 B4                 lda   SavePtr                  ; the first pointer is savesize past
0464 7901 18                    clc                            ; saveptr.
0465 7902 65 B8                 adc   SaveSize
0466 7904 85 78                 sta   CursorPtr1
0467 7906 A5 B6                 lda   SavePtr+2
0468 7908 69 00 00              adc   #0
0469 790B 85 7A                 sta   CursorPtr1+2
0470 790D
0471 790D A2 00 00              ldx   #0
0472 7910 B5 78        SetUpLoop lda   CursorPtr1,x
0473 7912 18                    clc   
0474 7913 65 B8                 adc   SaveSize
0475 7915 95 7C                 sta   CursorPtr1+4,x
0476 7917 B5 7A                 lda   CursorPtr1+2,x
0477 7919 69 00 00              adc   #0
0478 791C 95 7E                 sta   CursorPtr1+6,x
0479 791E E8                    inx   
0480 791F E8                    inx   
0481 7920 E8                    inx   
0482 7921 E8                    inx   
0483 7922 E0 34 00              cpx   #13*4                    ; 52, 7 sets of two pointers
0484 7925 90 E9                 bcc   SetUpLoop
0485 7927 60                    rts   
0486 7928
0487 7928                       END   
